hpGuiBoxSetGet = {};

function hpGuiBoxSetGet:insertGuiBoxLines()
	local guiBox = g_currentMission.hlHudSystem.guiMenu;
	if guiBox ~= nil then
		local linesSequence = {"heapPreviewHeadline_","heapPreviewOnOff_","heapPreviewRadius_","previewIngameBox_"};
		for k,v in pairs(linesSequence) do
			guiBox:addModLine( {lineCallSequence=v,getLine=function(args) return hpGuiBoxSetGet.getLines(args);end} );			
		end;		
	end;	
end;

function hpGuiBoxSetGet.getLines(args)
	local guiBox = args.guiBox;
	if guiBox == nil then return;end;	
	local lineCallSequence = args.lineCallSequence or "";
	local textOffColor = g_currentMission.hlHudSystem.overlays.color.notActive;
	local iconColor = g_currentMission.hlHudSystem.overlays.color.notActive;
	local onColor = g_currentMission.hlHudSystem.overlays.color.on;
	local stateOn = g_i18n:getText("ui_on");
	local stateOff = g_i18n:getText("ui_off");	
	local stateColor = nil;		
	local helpText = "";
	if lineCallSequence == "heapPreviewHeadline_" then	
		textL = "HeapPreview Settings";	
		return {typ="headline", text={[1]={text=textL, color="ls25"}} };
	end;
	if lineCallSequence == "heapPreviewOnOff_" then	
		textL = "HP ".. stateOn.. "/".. stateOff;
		if HeapPreview.values.isOn then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = "on = affects the performance of the game";
		return {onClick=hpGuiBoxSetGet.onClick, oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=HeapPreview.values.isOn}} };
	end;
	if lineCallSequence == "heapPreviewRadius_" then	
		textL = "HP Radius";
		if HeapPreview.values.isOn then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("action_terrainChangeRadius").. "\nlarge radius needs more performance (Default ".. tostring(HeapPreview.values.defaultRadius).. ")";
		if HeapPreview.values.isOn then			
			return {onClick=hpGuiBoxSetGet.onClick, typ="number", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={text=tostring(HeapPreview.values.radius)}} };
		else
			return {typ="string", text={[1]={text=textL,color=stateColor}} };
		end;
	end;
	if lineCallSequence == "previewIngameBox_" then
		textL = "HP over IngameBox";
		helpText = "Preview over LS Ingame Box. Default over F1 Menu";
		if HeapPreview.values.isOn then iconColor = onColor;else stateColor = textOffColor;end;
		if HeapPreview.values.isOn then	
			return {oneClick=true, onClick=hpGuiBoxSetGet.onClick, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=HeapPreview.values.viewIngameBox}} };
		else
			return {typ="string", text={[1]={text=textL,color=stateColor}} };
		end;
	end;
end;

function hpGuiBoxSetGet.onClick(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil then return;end;
	
	if args.isDown then
		if g_currentMission.hlUtils.dragDrop.on then return;end;
		if args.button == Input.MOUSE_BUTTON_LEFT then
			if args.clickAreaTable.areaClick == "line_" then --line oneClick
				if args.clickAreaTable.lineCallSequence == "heapPreviewOnOff_" then
					HeapPreview.values.isOn = not HeapPreview.values.isOn;
				elseif args.clickAreaTable.lineCallSequence == "previewIngameBox_" then
					HeapPreview.values.viewIngameBox = not HeapPreview.values.viewIngameBox;
				end;
			elseif args.clickAreaTable.areaClick == "text2_" then --colum right click
				if args.clickAreaTable.lineCallSequence == "heapPreviewRadius_" then
					if HeapPreview.values.radius+HeapPreview.values.radiusLV > HeapPreview.values.maxRadius then
						HeapPreview.values.radius = HeapPreview.values.minRadius;
					else
						HeapPreview.values.radius = HeapPreview.values.radius+HeapPreview.values.radiusLV;
					end;
				end;
			end;
		elseif args.button == Input.MOUSE_BUTTON_RIGHT then
			if args.clickAreaTable.areaClick == "text2_" then --colum right click
				if args.clickAreaTable.lineCallSequence == "heapPreviewRadius_" then
					if HeapPreview.values.radius-HeapPreview.values.radiusLV < HeapPreview.values.minRadius then
						HeapPreview.values.radius = HeapPreview.values.maxRadius;
					else
						HeapPreview.values.radius = HeapPreview.values.radius-HeapPreview.values.radiusLV;
					end;
				end;
			end;
		end;
	end;
end;