Utils = {}
Utils_mp = Class(Utils)

Utils.vehicleCategories = {
    "tractorsS",
    "tractorsM",
    "tractorsL",
    "trucks",
    "harvesters",
    "forageHarvesters",
    "potatoVehicles",
    "beetVehicles",
    "sugarcaneVehicles",
    "cottonVehicles",
    "grapeVehicles",
    "oliveVehicles",
    "woodHarvesting",
    "animalsVehicles",
    "sprayerVehicles",
    "slurryVehicles",
    "mowerVehicles",
    "frontLoaderVehicles",
    "wheelLoaderVehicles",
    "teleLoaderVehicles",
    "skidSteerVehicles",
    "forklifts",
    "cars",
    "miscVehicles"
}

Utils.excludeVehicleHotSpotTypes = {
    VehicleHotspot.TYPE.OTHER,
    VehicleHotspot.TYPE.TOOL,
    VehicleHotspot.TYPE.TOOL_TRAILED,
    VehicleHotspot.TYPE.TRAILER,
    VehicleHotspot.TYPE.CUTTER
}

Utils.excludePlaceableTypes = {
    "simplePlaceable"
}

function Utils:modulo(a, b)
    return a - math.floor(a / b) * b
end

function Utils:getPlayersCount()
    local count = 0

    for _, user in pairs(g_currentMission.userManager:getUsers()) do
        if user:getId() ~= 1 then -- bypass server
            count = count + 1
        end
    end

    return count
end

function Utils:getFarmlandOwner(farmland)
    local ownerId = farmland.farmId
    local nickname = nil

    if ownerId == AccessHandler.EVERYONE or ownerId == AccessHandler.NOBODY then
        local npc = farmland:getNPC()
        if npc ~= nil then
            nickname = ("NPC %s"):format(npc.title)
        end
    else
        local farm = g_farmManager:getFarmById(ownerId)
        if farm ~= nil then
            nickname = farm.name
        end
    end

    return nickname
end

function Utils:getFarmOwnerNickname(farm)
    local nickname = nil

    for _, player in ipairs(farm.players) do
        if player.isFarmManager then
            nickname = player.lastNickname
            break
        end
    end

    return nickname
end

function Utils:mpsToBeaufort(value)
    return math.floor((math.ceil(value) / 0.836) ^ 0.6666666666666666)
end

function Utils:windDirectionToRadian(diretion)
    return (math.rad(diretion) + math.pi)
end

function Utils:invertRotation(rotation)
    if rotation ~= nil then
        return (rotation + math.pi) % (2 * math.pi)
    end

    return rotation
end

function Utils:formatTemperature(temperature)
    local stringFormat = string.format("%1.0f", temperature)
    return tonumber(stringFormat)
end

function Utils:formatTimeValue(dayTime)
    local currentTime = dayTime / (1000 * 60 * 60)
    local timeHours = math.floor(currentTime)
    local timeMinutes = math.floor((currentTime - timeHours) * 60)

    return string.format("%02d:%02d", timeHours, timeMinutes)
end

function Utils:giantsToRgb(number, precision)
    --number = MathUtil.clamp(tonumber(number) or 0, 0, 1)

    local rgb = 0

    if number > 0.0031308 then
        rgb = 1.055 * (math.pow(number, (1.0 / 2.4))) - 0.055
    else
        rgb = 12.92 * number
    end

    return MathUtil.round(rgb * 255, precision)
end

function Utils:weatherIndexToType(index)
    -- local getCurrentWeatherType = g_currentMission.environment.weather:getCurrentWeatherType()
    local weatherType = nil;

    if index == WeatherType.SUN then
        weatherType = "SUN"
    elseif index == WeatherType.RAIN then
        weatherType = "RAIN"
    elseif index == WeatherType.CLOUDY then
        weatherType = "CLOUDY"
    elseif index == WeatherType.SNOW then
        weatherType = "SNOW"
    elseif index == WeatherType.TWISTER then
        weatherType = "TWISTER"
    elseif index == WeatherType.THUNDER then
        weatherType = "THUNDER"
    elseif index == WeatherType.PARTIALLY_CLOUDY then
        weatherType = "PARTIALLY_CLOUDY"
    elseif index == WeatherType.HAIL then
        weatherType = "HAIL"
    end;

    return weatherType
end

function Utils:placeableIndexToType(index)
    local placeableType = "UNKNOWN";

    if index == PlaceableHotspot.TYPE.LOADING then
        placeableType = "LOADING"
    elseif index == PlaceableHotspot.TYPE.UNLOADING then
        placeableType = "UNLOADING"
    elseif index == PlaceableHotspot.TYPE.UNLOADING_TRAIN then
        placeableType = "UNLOADING_TRAIN"
    elseif index == PlaceableHotspot.TYPE.PRODUCTION_POINT then
        placeableType = "PRODUCTION_POINT"
    elseif index == PlaceableHotspot.TYPE.SHOP then
        placeableType = "SHOP"
    elseif index == PlaceableHotspot.TYPE.FARM then
        placeableType = "FARM"
    elseif index == PlaceableHotspot.TYPE.FUEL then
        placeableType = "FUEL"
    elseif index == PlaceableHotspot.TYPE.ELECTRICITY then
        placeableType = "ELECTRICITY"
    elseif index == PlaceableHotspot.TYPE.SHOP_ANIMAL then
        placeableType = "SHOP_ANIMAL"
    elseif index == PlaceableHotspot.TYPE.CHICKEN then
        placeableType = "CHICKEN"
    elseif index == PlaceableHotspot.TYPE.PIG then
        placeableType = "PIG"
    elseif index == PlaceableHotspot.TYPE.SHEEP then
        placeableType = "SHEEP"
    elseif index == PlaceableHotspot.TYPE.COW then
        placeableType = "COW"
    elseif index == PlaceableHotspot.TYPE.HORSE then
        placeableType = "HORSE"
    elseif index == PlaceableHotspot.TYPE.TRAIN then
        placeableType = "TRAIN"
    elseif index == PlaceableHotspot.TYPE.BEE then
        placeableType = "BEE"
    elseif index == PlaceableHotspot.TYPE.EXCLAMATION_MARK then
        placeableType = "EXCLAMATION_MARK"
    end

    return placeableType
end

function Utils:vehicleHotSpotIndexToType(index)
    local vehicleHotSpotType = "OTHER";

    if index == VehicleHotspot.TYPE.TRACTOR then
        vehicleHotSpotType = "TRACTOR"
    elseif index == VehicleHotspot.TYPE.TRUCK then
        vehicleHotSpotType = "TRUCK"
    elseif index == VehicleHotspot.TYPE.CAR then
        vehicleHotSpotType = "CAR"
    elseif index == VehicleHotspot.TYPE.HARVESTER then
        vehicleHotSpotType = "HARVESTER"
    elseif index == VehicleHotspot.TYPE.WHEELLOADER then
        vehicleHotSpotType = "WHEELLOADER"
    elseif index == VehicleHotspot.TYPE.TRAILER then
        vehicleHotSpotType = "TRAILER"
    elseif index == VehicleHotspot.TYPE.TOOL then
        vehicleHotSpotType = "TOOL"
    elseif index == VehicleHotspot.TYPE.TOOL_TRAILED then
        vehicleHotSpotType = "TOOL_TRAILED"
    elseif index == VehicleHotspot.TYPE.CUTTER then
        vehicleHotSpotType = "CUTTER"
    elseif index == VehicleHotspot.TYPE.OTHER then
        vehicleHotSpotType = "OTHER"
    elseif index == VehicleHotspot.TYPE.HORSE then
        vehicleHotSpotType = "HORSE"
    elseif index == VehicleHotspot.TYPE.TRAIN then
        vehicleHotSpotType = "TRAIN"
    end

    return vehicleHotSpotType
end

function Utils:debugPrint(text, ...)
    Logging.info(text, ...)
end

function Utils:debugTable(table)
    DebugUtil.printTableRecursively(table, "_", 0, 1)
end

function Utils:includes(table, element)
    for _, value in ipairs(table) do
        if string.upper(value) == string.upper(element) then
            return true
        end
    end

    return false
end
