---@class VehicleReloadEvent
VehicleReloadEvent = {}
local VehicleReloadEvent_mt = Class(VehicleReloadEvent, Event)

InitEventClass(VehicleReloadEvent, "VehicleReloadEvent")

function VehicleReloadEvent.emptyNew()
  vsDebug("VRE-emptyNew")
	return Event.new(VehicleReloadEvent_mt)
end

function VehicleReloadEvent.new(farmId)
  vsDebug("VRE-new")
	local self = VehicleReloadEvent.emptyNew()
  self.farmId = farmId
	return self
end

function VehicleReloadEvent:readStream(streamId, connection)
  vsDebug("VRE-readStream")
  -- Get data from clients
  self.farmId = streamReadUIntN(streamId, FarmManager.FARM_ID_SEND_NUM_BITS)
	self:run(connection)
end

function VehicleReloadEvent:writeStream(streamId, connection)
  vsDebug("VRE-writeStream")
  -- Send data out to clients
  streamWriteUIntN(streamId, self.farmId, FarmManager.FARM_ID_SEND_NUM_BITS)
end

function VehicleReloadEvent:run(connection)
  vsDebug("VRE-run")
  g_workshopStorageScreen:reloadVehicles(self.farmId)
end

function VehicleReloadEvent.sendEvent(farmId)
  vsDebug("VRE-sendEvent")
	if g_server ~= nil then
    if g_client:getServerConnection():getIsLocal() and g_dedicatedServer == nil then
      vsDebug("VRE Local Server Host")
      g_workshopStorageScreen:reloadVehicles(farmId)
    else
      vsDebug("VRE Dedicated Server Host")
  		g_server:broadcastEvent(VehicleReloadEvent.new(farmId))
    end
    return
	end
  vsDebug("VRE Client")
	g_client:getServerConnection():sendEvent(VehicleReloadEvent.new(farmId))
end