-- Main.lua
-- Script principal para el mod AI Vehicle Tracks en Farming Simulator 25
-- Soporte multilingüe: español, inglés, alemán
--- @author KCHARRO
--- @version 1.0

-- Main.lua modificado para incluir el control de arado
local AIVehicleTracks = {}
AIVehicleTracks_mt = Class(AIVehicleTracks)

function AIVehicleTracks:new()
    local self = {}
    setmetatable(self, AIVehicleTracks_mt)
    
    self.modName = {
        en = "AI Vehicle Tracks",
        es = "Huellas de vehículos IA",
        de = "KI-Fahrzeugspuren"
    }
    
    self.modVersion = "1.0.0.0"
    self.modDebug = true
    
    self.scriptsToLoad = {
        "scripts/aiGround.lua",
        "scripts/aiTracks.lua",
        -- "scripts/plowDepthLimiter.lua"
    }
    
    return self
end

-- Sistema de traducción mejorado
function AIVehicleTracks:setupTranslations()
    self.translations = {
        log = {
            loading = {
                en = "Loading mod v",
                es = "Cargando mod v",
                de = "Lade Mod v"
            },
            scriptLoaded = {
                en = "Script loaded successfully: ",
                es = "Script cargado correctamente: ",
                de = "Skript erfolgreich geladen: "
            },
            scriptRegistered = {
                en = "Script already registered: ",
                es = "Script ya registrado: ",
                de = "Skript bereits registriert: "
            },
            fileNotFound = {
                en = "ERROR: File not found - ",
                es = "ERROR: Archivo no encontrado - ",
                de = "FEHLER: Datei nicht gefunden - "
            },
            allComponents = {
                en = "All components loaded successfully",
                es = "Todos los componentes cargados correctamente",
                de = "Alle Komponenten erfolgreich geladen"
            },
            someComponents = {
                en = "Warning: Some components failed to load",
                es = "Advertencia: Algunos componentes no se cargaron",
                de = "Warnung: Einige Komponenten konnten nicht geladen werden"
            }
        }
    }
end

-- Función para obtener idioma con seguridad
function AIVehicleTracks:getCurrentLanguage()
    if g_currentMission ~= nil and g_currentMission.languageShort ~= nil then
        return g_currentMission.languageShort
    end
    return "en"
end

-- Sistema de logging mejorado
function AIVehicleTracks:log(messageKey, isDebug, additionalText)
    if not isDebug or (isDebug and self.modDebug) then
        local lang = self:getCurrentLanguage()
        local message = self.translations.log[messageKey][lang] or self.translations.log[messageKey]["en"]
        print("["..self.modName[lang].."] "..message..(additionalText or ""))
    end
end

-- Nueva implementación segura para registrar el mod
function AIVehicleTracks:register()
    -- Método 1: Usar addModEventListener si está disponible
    if addModEventListener then
        addModEventListener(self)
        return true
    end
    
    -- Método 2: Registro manual cuando la misión esté lista
    if g_currentMission then
        if g_currentMission.addUpdateable then
            g_currentMission:addUpdateable(self)
        else
            g_currentMission.aiVehicleTracks = self
        end
        return true
    end
    
    -- Método 3: Usar eventos de carga de mapa
    Mission00.load = Utils.appendedFunction(Mission00.load, function()
        if g_currentMission and g_currentMission.addUpdateable then
            g_currentMission:addUpdateable(self)
        end
    end)
    
    return true
end

-- Instanciar y registrar el mod
local aiVehicleTracks = AIVehicleTracks:new()

-- Intentar registro inmediato o diferido
if not aiVehicleTracks:register() then
    -- Fallback final si todo lo demás falla
    print("["..aiVehicleTracks.modName.en.."] Using alternative registration method")
    local function delayedRegister()
        if g_currentMission and g_currentMission.addUpdateable then
            g_currentMission:addUpdateable(aiVehicleTracks)
            removeEventListener("onUpdate", delayedRegister)
        end
    end
    addEventListener("onUpdate", delayedRegister)
end
-- Cargar scripts con manejo de errores mejorado
function AIVehicleTracks:loadScript(scriptPath)
    if not fileExists(scriptPath) then
        self:log("fileNotFound", false, scriptPath)
        return false
    end
    
    if g_specializationManager:getSpecializationByName(scriptPath) ~= nil then
        self:log("scriptRegistered", true, scriptPath)
        return true
    end
    
    local success, result = pcall(source, scriptPath)
    if success then
        self:log("scriptLoaded", false, scriptPath)
        return true
    else
        print("["..self.modName.en.."] ERROR loading "..scriptPath..": "..tostring(result))
        return false
    end
end

-- Inicialización principal
function AIVehicleTracks:load()
    self:setupTranslations()
    self:log("loading", false, self.modVersion)
    
    local allLoaded = true
    for _, scriptPath in ipairs(self.scriptsToLoad) do
        if not self:loadScript(scriptPath) then
            allLoaded = false
        end
    end
    
    if allLoaded then
        self:log("allComponents", false)
    else
        self:log("someComponents", false)
    end
    
    -- Inicializar submódulos si existen
    if aiGround ~= nil and aiGround.init ~= nil then
        aiGround.init()
    end
    
    if aiTracks ~= nil and aiTracks.init ~= nil then
        aiTracks.init()
    end
    
    -- Inicializar control de arado si existe(en un futuro implementar profundidad dinámica del suelo a más de 0.2 según humedad y contenido de agua del suelo)
        
        --if plowDepthLimiter ~= nil and plowDepthLimiter.init ~= nil then
        --    -plowDepthLimiter.init()
        --end
        
    return true
end

-- Eventos del juego
function AIVehicleTracks:loadMap()
    if aiGround ~= nil and aiGround.loadMap ~= nil then
        aiGround.loadMap()
    end
    
    if aiTracks ~= nil and aiTracks.loadMap ~= nil then
        aiTracks.loadMap()
    end
end

function AIVehicleTracks:update(dt)
    if aiGround ~= nil and aiGround.update ~= nil then
        aiGround.update(dt)
    end
    
    if aiTracks ~= nil and aiTracks.update ~= nil then
        aiTracks.update(dt)
    end
end

function AIVehicleTracks:delete()
    -- Limpieza si es necesaria
end

-- Instanciar y registrar el mod
local aiVehicleTracks = AIVehicleTracks:new()

-- Intentar registro inmediato o diferido
if not aiVehicleTracks:register() then
    -- Fallback final si todo lo demás falla
    print("["..aiVehicleTracks.modName.en.."] Using alternative registration method")
    local function delayedRegister()
        if g_currentMission and g_currentMission.addUpdateable then
            g_currentMission:addUpdateable(aiVehicleTracks)
            removeEventListener("onUpdate", delayedRegister)
        end
    end
    addEventListener("onUpdate", delayedRegister)
end