--[[--------------------------------------------------------------------------------------------------
SUBVENTION
------------------------------------------------------------------------------------------------------
file: subventionModule
author:	Team LTW
start project: 07.12.2017
------------------------------------------------------------------------------------------------------
Farming Simulator 17
V1.0.0.0 - 06.11.2018

Farming Simulator 19
V1.0.0.0 - 16.05.2019 - converted to Farming Simulator 19
V1.1.0.0 - 14.08.2019 - seasons ready

Farming Simulator 22
V1.0.0.0 - 25.04.2022 - converted to Farming Simulator 22

Farming Simulator 25
V1.0.0.0 - 18.04.2025 - converted to Farming Simulator 25
------------------------------------------------------------------------------------------------------
copyright (c) Team LTW
----------------------------------------------------------------------------------------------------]]
subvention = {}

function subvention:growthSeasonal()
	if g_currentMission.missionInfo.growthMode ~= 1 then
		return false
	end
	return true
end

function subvention:getOwnedFieldSize()
	local fields = 0
	fields = g_farmlandManager.farmlands
	local fieldSize = 0	
	local i = 1
	while i <= #fields do
		if fields[i] ~= nil then
			if fields[i].isOwned == true and g_farmlandManager.farmlandMapping[i] == financeExtent.farmId then
				local fieldArea = fields[i].areaInHa
				if fieldArea > 0 then
					fieldSize = fieldSize + fieldArea
				end
			end
		end	
		i = i + 1
	end
	fieldSize = (math.ceil(fieldSize * 10)) / 10
	return fieldSize
end

function subvention:getSubventionAmount()
	local basicPremium = financeExtent.basicPremium
	local greening = financeExtent.greening
	local firstHa = financeExtent.firstHa			--first 40ha
	local furtherHa = financeExtent.furtherHa		--further 20ha
	local youngFarmer = financeExtent.youngFarmer
	local currentDay = g_currentMission.environment.currentDay
	
	-- basic and greening premium
	local ownedFieldSize = 0
	ownedFieldSize = self:getOwnedFieldSize()		
	local amountBasic = 0		
	amountBasic = (basicPremium + (greening * 0.01)) * ownedFieldSize
	
	-- small farmer premium
	local amountFirstHa = 0
	local amountFurtherHa = 0
	local amountSmallFarmer = 0	
	if ownedFieldSize <= 120 then
		if ownedFieldSize <= 40 then
			amountFirstHa = firstHa * ownedFieldSize;
		end
		if ownedFieldSize > 40 and ownedFieldSize <= 60 then
			amountFurtherHa = furtherHa * (ownedFieldSize - 40)
		end	
		amountSmallFarmer = amountFirstHa + amountFurtherHa
	end

	-- young farmer premium
	local amountYoungFarmer = 0
	if	self.growthSeasonal() == false then	
		if ownedFieldSize <= 120 and currentDay <= 25 then
			amountYoungFarmer = youngFarmer * ownedFieldSize
		end
	else
		local currentYear = g_currentMission.environment.currentYear
		if ownedFieldSize <= 120 and currentYear <= 5 then		-- 0 = first year
			amountYoungFarmer = youngFarmer * ownedFieldSize
		end
	end
	
	-- total premium
	local subventionAmount = 0
	subventionAmount = amountBasic + amountSmallFarmer + amountYoungFarmer

	return subventionAmount
end;

function subvention:economicDifficulty()
	local subvention = 0
	local economicDifficulty = g_currentMission.missionInfo.economicDifficulty
	
	if self.growthSeasonal() == false then
		if economicDifficulty == 1 then
			subvention = (math.floor ((self:getSubventionAmount() / 2.5) * 100)) / 100
		elseif economicDifficulty == 2 then
			subvention = (math.floor ((self:getSubventionAmount() / 3.33) * 100)) / 100
		elseif economicDifficulty == 3 then
			subvention = (math.floor ((self:getSubventionAmount() / 5) * 100)) / 100
		end
	else
		if economicDifficulty == 1 then
			subvention = (math.floor((self:getSubventionAmount() * 2) * 100)) / 100
		elseif economicDifficulty == 2 then
			subvention = (math.floor((self:getSubventionAmount() * 1.5) * 100)) / 100
		elseif economicDifficulty == 3 then
			subvention = (math.floor((self:getSubventionAmount() * 100))) / 100
		end
	end
	return subvention
end

function subvention:enablePayTime()
	if self.growthSeasonal() == false then
		if g_currentMission.environment.currentHour == 15 then
			return true
		end
	else
		local dayInPeriod = g_currentMission.environment.currentDayInPeriod
		local currentPeriod = g_currentMission.environment.currentPeriod
		if dayInPeriod == 1 and currentPeriod == 11 then
			if g_currentMission.environment.currentHour == 15 then
				return true
			end		
		end
	end
	return false
end;

function subvention:payTime()
	if g_currentMission.environment.currentHour == 16 then	
			return true
	end
	return false
end