--[[
    CustomGetAdminAnswerEvent

    Event to answer the CustomGetAdminEvent request for admin login.

    @author: 		BayernGamers
    @date: 			09.04.2025
    @version:		1.0

    History:		v1.0 @09.04.2025 - initial implementation in FS 22
                    ------------------------------------------------------------------------------------------------------
    
    License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
                        Attribution:
                            You must give appropriate credit to the original author when using this work.
                        No Derivatives:
                            You may not alter, transform, or build upon this work in any way.
                        Usage: 
                            The work may be used for personal and commercial purposes, provided it is not modified or adapted.
                        Additional Clause:
                            This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "CustomGetAdminAnswerEvent.lua")

CustomGetAdminAnswerEvent = {}
local CustomGetAdminAnswerEvent_mt = Class(CustomGetAdminAnswerEvent, Event)

--InitEventClass(CustomGetAdminAnswerEvent, "CustomGetAdminAnswerEvent")
EventIds.assignEventObjectId(CustomGetAdminAnswerEvent, "CustomGetAdminAnswerEvent", EventIds.eventIdNext)

CustomGetAdminAnswerEvent.ACCESS_GRANTED = 0
CustomGetAdminAnswerEvent.ACCESS_DENIED = 1
CustomGetAdminAnswerEvent.NOT_SUPPORTED = 2
CustomGetAdminAnswerEvent.sendNumBits = 2

function CustomGetAdminAnswerEvent.emptyNew()
	local self = Event.new(CustomGetAdminAnswerEvent_mt)

	return self
end

function CustomGetAdminAnswerEvent.new(state)
	log:printDevInfo("Creating new event", LoggingUtil.DEBUG_LEVELS.HIGH)
	local self = CustomGetAdminAnswerEvent.emptyNew()
	self.state = state

	return self
end

function CustomGetAdminAnswerEvent:readStream(streamId, connection)
	log:printDevInfo("Reading stream", LoggingUtil.DEBUG_LEVELS.HIGH)
	self.state = streamReadUIntN(streamId, CustomGetAdminAnswerEvent.sendNumBits)

	self:run(connection)
end

function CustomGetAdminAnswerEvent:writeStream(streamId, connection)
	log:printDevInfo("Writing stream", LoggingUtil.DEBUG_LEVELS.HIGH)
	streamWriteUIntN(streamId, self.state, CustomGetAdminAnswerEvent.sendNumBits)
end

function CustomGetAdminAnswerEvent:run(connection)
    log:printDevInfo("Run Called!", LoggingUtil.DEBUG_LEVELS.HIGH)
	if connection:getIsServer() then
        log:printDevInfo("Publishing admin login response to message center", LoggingUtil.DEBUG_LEVELS.HIGH)
        g_messageCenter:publish(CustomGetAdminAnswerEvent, self.state)
	else
		log:printError("This function should only be called on the server side.")
	end
end
