--[[
    CustomGetAdminEvent

    Event to request admin access from the server.

    @author: 		BayernGamers
    @date: 			09.04.2025
    @version:		1.0

    History:		v1.0 @09.04.2025 - initial implementation in FS 22
                    ------------------------------------------------------------------------------------------------------
    
    License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
                        Attribution:
                            You must give appropriate credit to the original author when using this work.
                        No Derivatives:
                            You may not alter, transform, or build upon this work in any way.
                        Usage: 
                            The work may be used for personal and commercial purposes, provided it is not modified or adapted.
                        Additional Clause:
                            This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "CustomGetAdminEvent.lua")

CustomGetAdminEvent = {}
local CustomGetAdminEvent_mt = Class(CustomGetAdminEvent, Event)

--InitEventClass(CustomGetAdminEvent, "CustomGetAdminEvent")
EventIds.assignEventObjectId(CustomGetAdminEvent, "CustomGetAdminEvent", EventIds.eventIdNext)

function CustomGetAdminEvent.emptyNew()
	local self = Event.new(CustomGetAdminEvent_mt)

	return self
end

function CustomGetAdminEvent.new(password)
	log:printDevInfo("Creating new event", LoggingUtil.DEBUG_LEVELS.HIGH)
	local self = CustomGetAdminEvent.emptyNew()
	self.password = password

	return self
end

function CustomGetAdminEvent:readStream(streamId, connection)
	log:printDevInfo("Reading stream", LoggingUtil.DEBUG_LEVELS.HIGH)
	assert(g_currentMission:getIsServer())

	self.password = streamReadString(streamId)

	if g_currentMission:getIsServer() and not connection:getIsServer() then
		local state = GetAdminAnswerEvent.NOT_SUPPORTED

		if g_dedicatedServer ~= nil then
			if g_dedicatedServer.adminPassword == self.password then
				state = GetAdminAnswerEvent.ACCESS_GRANTED

				g_currentMission.userManager:addMasterUserByConnection(connection)
				log:printDevInfo("Number of Master Users: " .. tostring(g_currentMission.userManager:getNumberOfMasterUsers()), LoggingUtil.DEBUG_LEVELS.HIGH)
			else
				state = GetAdminAnswerEvent.ACCESS_DENIED
			end
		end

		log:printDevInfo("Sending admin login response to client", LoggingUtil.DEBUG_LEVELS.HIGH)
		log:printDevInfo("Connection state: " .. tostring(connection.isConnected), LoggingUtil.DEBUG_LEVELS.HIGH)
		log:printDevInfo("StreamId: " .. tostring(connection.streamId), LoggingUtil.DEBUG_LEVELS.HIGH)
		log:printDevInfo("IsReadyForEvents: " .. tostring(connection.isReadyForEvents), LoggingUtil.DEBUG_LEVELS.HIGH)
		connection:sendEvent(CustomGetAdminAnswerEvent.new(state), false, true)
	end
end

function CustomGetAdminEvent:writeStream(streamId, connection)
	log:printDevInfo("Writing stream", LoggingUtil.DEBUG_LEVELS.HIGH)
	streamWriteString(streamId, self.password)
end

function CustomGetAdminEvent:run(connection)
	print("Error: CustomGetAdminEvent is a client to server only event")
end
